--------------------------------------------------------------------------
-- GTFO_Fail_SL.lua 
--------------------------------------------------------------------------
--[[
GTFO Fail List - Shadowlands
]]--

if (not (GTFO.ClassicMode or GTFO.BurningCrusadeMode)) then

--- ***********************
--- * Shadowlands (World) *
--- ***********************

GTFO.SpellID["325423"] = {
  --desc = "Mawsworn Lance (Mawsworn Kyrian)";
  sound = 3;
};

GTFO.SpellID["325246"] = {
  --desc = "Spikes";
  sound = 3;
};

GTFO.SpellID["308502"] = {
  --desc = "Unstable Shadows (Gor'groth)";
  sound = 3;
};

GTFO.SpellID["305515"] = {
  --desc = "Necrotic Breath (Ravnyr)";
  sound = 3;
};

GTFO.SpellID["340207"] = {
  --desc = "Anima Flash (Aethon)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["332569"] = {
  --desc = "Pinning Spear (Fallen Acolyte Erisne)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["343090"] = {
  --desc = "Dissonance";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["329569"] = {
  --desc = "Void Collapse (Seething Voidripper)";
  sound = 3;
};

GTFO.SpellID["308838"] = {
  --desc = "Void Rain";
  sound = 3;
};

GTFO.SpellID["331270"] = {
  --desc = "Fling Goop (Diseased Remnant)";
  sound = 3;
};

GTFO.SpellID["330404"] = {
  --desc = "Wing Buffet (Gristlebeak)";
  sound = 3;
};

GTFO.SpellID["322014"] = {
  --desc = "Risen Shadows (Architect Halen)";
  sound = 3;
};

GTFO.SpellID["320028"] = {
  --desc = "Ground Pound (Strategist Ocra)";
  sound = 3;
};

GTFO.SpellID["333710"] = {
  --desc = "Grasping Hands (Sharrex the Fleshcrafter)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["320734"] = {
  --desc = "Massive Strike (Brethlun the Brand)";
  sound = 3;
};

GTFO.SpellID["320726"] = {
  --desc = "Colossal Exhumation (Brethlun the Brand)";
  sound = 3;
};

GTFO.SpellID["334509"] = {
  --desc = "Warlord's Slam (Baron Vyraz)";
  sound = 3;
};

GTFO.SpellID["342704"] = {
  --desc = "Rotting Tempest (Rotbriar Boggart)";
  sound = 3;
};

GTFO.SpellID["314182"] = {
  --desc = "Sin Lash";
  sound = 3;
};

GTFO.SpellID["321366"] = {
  --desc = "Crimson Barrage (Lady Inerva Darkvein)";
  sound = 3;
  negatingBuffSpellID = 321345; -- Harvester's Might
};

GTFO.SpellID["342499"] = {
  --desc = "Lurking Eruption (Niya, As Xavius)";
  sound = 3;
};

GTFO.SpellID["342488"] = {
  --desc = "Nightmare Blades (Niya, As Xavius)";
  sound = 3;
};

GTFO.SpellID["340808"] = {
  --desc = "Armageddon (Glimmerdust, As Kil'jaeden)";
  sound = 3;
};

GTFO.SpellID["340566"] = {
  --desc = "Poison Bomb (Invasive Terror)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["340639"] = {
  --desc = "Binding Fungus (Humon'gozz)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["345454"] = {
  --desc = "Magma Wave (Borr-Geth)";
  sound = 3;
};

GTFO.SpellID["341562"] = {
  --desc = "Nightmare Blades (Niya, As Xavius)";
  sound = 3;
};

GTFO.SpellID["341548"] = {
  --desc = "Lurking Eruption (Niya, As Xavius)";
  sound = 3;
};

GTFO.SpellID["324603"] = {
  --desc = "Ashen Winds";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["317783"] = {
  --desc = "Shadow Eruption (Soul Well)";
  sound = 3;
};

GTFO.SpellID["344988"] = {
  --desc = "Shower of Misery (Drifting Sorrow)";
  sound = 3;
};

GTFO.SpellID["346251"] = {
  --desc = "Anima Nova (Ghastly Willbreaker)";
  sound = 3;
};

GTFO.SpellID["346439"] = {
  --desc = "Culling Blades (Seeker Xeros)";
  sound = 3;
};

GTFO.SpellID["338855"] = {
  --desc = "Seeds of Sorrow (Oranomonos the Everbranching)";
  sound = 3;
};

GTFO.SpellID["341747"] = {
  --desc = "Overwhelming Misery (Wailing Soul)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["342886"] = {
  --desc = "Twilight Dust (The Slumbering Emperor)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["330642"] = {
  --desc = "Venomous Blast (Gorm Behemoth)";
  sound = 3;
};

GTFO.SpellID["295985"] = {
  --desc = "Ground Crush (The Grand Malleare)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["332655"] = {
  --desc = "Cantrip of Flame (Scrivener Lenua)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["343520"] = {
  --desc = "Storming";
  sound = 3;
};

GTFO.SpellID["342494"] = {
  --desc = "Belligerent Boast (Manifestation of Pride)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["353404"] = {
  --desc = "Residual Blast";
  sound = 3;
};

GTFO.SpellID["340770"] = {
  --desc = "Glacial Ray (Glimmerdust, As Jaina)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["357236"] = {
  --desc = "Tormenting Flames (Kroke the Tormented)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["358316"] = {
  --desc = "Focused Conduit (Ve'rayn)";
  sound = 3;
};

GTFO.SpellID["357871"] = {
  --desc = "Death Wave (Dominated Protector)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["355561"] = {
  --desc = "Slumber (Slumbering Swarm)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["357951"] = {
  --desc = "Stygian Rain (Consumption)";
  sound = 3;
};

GTFO.SpellID["355458"] = {
  --desc = "Damnation (Mor'geth)";
  sound = 3;
};

GTFO.SpellID["353752"] = {
  --desc = "Cries of Anguish (Mor'geth)";
  sound = 3;
};

GTFO.SpellID["357179"] = {
  --desc = "Blazing Inferno (Mawforged Construct)";
  sound = 3;
};

GTFO.SpellID["358004"] = {
  --desc = "Unleashed Soulstorm (Screaming Shade)";
  sound = 3;
};

GTFO.SpellID["335447"] = {
  --desc = "Hungering Eruption (Wild Worldcracker)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["358357"] = {
  --desc = "Effigy of Torment (Towering Exterminator)";
  sound = 3;
};

GTFO.SpellID["358091"] = {
  --desc = "Devouring Rift (Xyraxz the Unknowable)";
  sound = 3;
};

GTFO.SpellID["356414"] = {
  --desc = "Frost Lance (Oros Coldheart)";
  sound = 3;
};

GTFO.SpellID["358973"] = {
  --desc = "Wave of Terror (Executioner Varruth)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["353763"] = {
  --desc = "Leeching Cleave (Nal'ragas)";
  sound = 3;
};

GTFO.SpellID["355737"] = {
  --desc = "Scorching Blast (Incinerator Arkolath)";
  sound = 3;
};


--- **********************
--- * Halls of Atonement *
--- **********************

GTFO.SpellID["326440"] = {
  --desc = "Sin Quake (Shard of Halkias)";
  sound = 3;
};

GTFO.SpellID["346866"] = {
  --desc = "Stone Breath (Loyal Stoneborn)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["322945"] = {
  --desc = "Heave Debris (Halkias)";
  sound = 3;
};

GTFO.SpellID["338013"] = {
  --desc = "Anima Fountain (Anima Fountain)";
  sound = 3;
};

GTFO.SpellID["323126"] = {
  --desc = "Telekinetic Collision (Lord Chamberlain)";
  sound = 3
};

GTFO.SpellID["314926"] = {
  --desc = "Soul Surge";
  sound = 3;
};

GTFO.SpellID["338848"] = {
  --desc = "Spine Crawl (Mortanis)";
  sound = 3;
};

GTFO.SpellID["337196"] = {
  --desc = "Active Volcano";
  sound = 3;
};

GTFO.SpellID["336809"] = {
  --desc = "Soul Fissure (Azmogal)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["336893"] = {
  --desc = "Terrifying Chaos (Azmogal)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["337072"] = {
  --desc = "Deathshade Volley (Deathshade of Xantuth)";
  sound = 3;
};

GTFO.SpellID["336945"] = {
  --desc = "Hurl Boulders (Unbreakable Urtz)";
  sound = 3;
};

--- **************
--- * Plaguefall *
--- **************

GTFO.SpellID["328012"] = {
  --desc = "Binding Fungus";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["328019"] = {
  --desc = "Plague Bore (Plagueborer)";
  sound = 3;
};

GTFO.SpellID["327233"] = {
  --desc = "Belch Plague (Plaguebelcher)";
  sound = 3;
};

GTFO.SpellID["326242"] = {
  --desc = "Slime Wave (Globgrog)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["328501"] = {
  --desc = "Plague Bomb (Rigged Plagueborer)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["320519"] = {
  --desc = "Jagged Spines (Blighted Spinebreaker)";
  sound = 3;
};

GTFO.SpellID["318949"] = {
  --desc = "Festering Belch (Blighted Spinebreaker)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["328986"] = {
  --desc = "Violent Detonation (Unstable Canister)";
  sound = 3;
};

GTFO.SpellID["329217"] = {
  --desc = "Slime Lunge (Doctor Ickus)";
  sound = 3;
};

GTFO.SpellID["330026"] = {
  --desc = "Slime Lunge (Doctor Ickus)";
  sound = 3;
};

GTFO.SpellID["323572"] = {
  --desc = "Rolling Plague (Plagueborer)";
  sound = 3;
};

GTFO.SpellID["322475"] = {
  --desc = "Plague Crash (Margrave Stradama)";
  sound = 3;
};

--- *******************
--- * Sanguine Depths *
--- *******************

GTFO.SpellID["320999"] = {
  --desc = "Echoing Thrust (Regal Mistdancer)";
  sound = 3;
};

GTFO.SpellID["320991"] = {
  --desc = "Echoing Thrust (Regal Mistdancer)";
  sound = 3;
};

GTFO.SpellID["334921"] = {
  --desc = "Umbral Crash (Insatiable Brute)";
  sound = 3;
  damageMinimum = 20000;
  test = true;
};

GTFO.SpellID["322418"] = {
  --desc = "Craggy Fracture (Chamber Sentinel)";
  sound = 3;
};

GTFO.SpellID["334378"] = {
  --desc = "Explosive Vellum (Research Scribe)";
  sound = 3;
};

GTFO.SpellID["322429"] = {
  --desc = "Severing Slice (Chamber Sentinel)";
  applicationOnly = true;
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["328494"] = {
  --desc = "Sintouched Anima";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["325885"] = {
  --desc = "Anguished Cries (Z'rali)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["323810"] = {
  --desc = "Piercing Blur (General Kaal)";
  sound = 3;
};

GTFO.SpellID["334563"] = {
  --desc = "Volatile Trap (Dreadful Huntmaster)";
  sound = 3;
};

--- ***********************
--- * Spires of Ascension *
--- ***********************

GTFO.SpellID["317943"] = {
  --desc = "Sweeping Blow (Forsworn Vanguard)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["324370"] = {
  --desc = "Attenuated Barrage (Azules)";
  sound = 3;
};

GTFO.SpellID["327693"] = {
  --desc = "Dark Salvo (Forsworn Annihilator)";
  sound = 3;
};

GTFO.SpellID["324141"] = {
  --desc = "Dark Bolt (Ventunax)";
  sound = 3;
};

GTFO.SpellID["323740"] = {
  --desc = "Impact (Forsworn Helion)";
  sound = 3;
};

GTFO.SpellID["324205"] = {
  --desc = "Blinding Flash (Ventunax)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["328332"] = {
  --desc = "Dark Secrets (Forsworn Justicar)";
  sound = 3;
};

GTFO.SpellID["323372"] = {
  --desc = "Empyreal Ordnance (Oryphrion)";
  sound = 3;
};

GTFO.SpellID["324608"] = {
  --desc = "Charged Stomp (Oryphrion)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["336444"] = {
  --desc = "Crescendo (Forsworn Helion)";
  sound = 3;
};

GTFO.SpellID["328466"] = {
  --desc = "Charged Spear (Astronos)";
  sound = 3;
};

GTFO.SpellID["334625"] = {
  --desc = "Abyssal Detonation (Devos)";
  sound = 3;
  negatingDebuffSpellID = 335805; -- Archon's Bastion
};

GTFO.SpellID["323831"] = {
  --desc = "Death Grasp (Mordretha, the Endless Empress)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["336420"] = {
  --desc = "Diminuendo (Lakesis)";
  sound = 3;
};

GTFO.SpellID["323943"] = {
  --desc = "Run Through (Devos)";
  sound = 3;
};

--- *************************
--- * Mists of Tirna Scithe *
--- *************************

GTFO.SpellID["321968"] = {
  --desc = "Bewildering Pollen (Tirnenn Villager)";
  sound = 3;
};

GTFO.SpellID["323137"] = {
  --desc = "Bewildering Pollen (Droman Oulfarran)";
  sound = 3;
};

GTFO.SpellID["331748"] = {
  --desc = "Back Kick (Mistveil Guardian)";
  sound = 3;
};

GTFO.SpellID["340304"] = {
  --desc = "Poisonous Secreations (Mistveil Gorgegullet)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["336759"] = {
  --desc = "Dodge Ball (Mistcaller)";
  sound = 3;
};

GTFO.SpellID["321834"] = {
  --desc = "Dodge Ball (Mistcaller)";
  sound = 3;
};

GTFO.SpellID["321893"] = {
  --desc = "Freezing Burst (Illusionary Vulpin)";
  sound = 3;
};

GTFO.SpellID["326022"] = {
  --desc = "Acid Globule (Spinemaw Gorger)";
  sound = 3;
};

GTFO.SpellID["322655"] = {
  --desc = "Acid Expulsion (Tred'ova)";
  sound = 3;
};

GTFO.SpellID["326263"] = {
  --desc = "Anima Shedding (Tred'ova)";
  sound = 3;
};

--- *******************
--- * Theater of Pain *
--- *******************

GTFO.SpellID["332708"] = {
  --desc = "Ground Smash (Heavin the Breaker)";
  sound = 3;
};

GTFO.SpellID["342126"] = {
  --desc = "Brutal Leap (Dokigg the Brutalizer)";
  sound = 3;
};

GTFO.SpellID["334025"] = {
  --desc = "Bloodthirsty Charge (Harugia the Bloodthirsty)";
  sound = 3;
};

GTFO.SpellID["317231"] = {
  --desc = "Crushing Slam (Xav the Unfallen)";
  sound = 3;
};

GTFO.SpellID["320729"] = {
  --desc = "Massive Cleave (Xav the Unfallen)";
  sound = 3;
};

GTFO.SpellID["317605"] = {
  --desc = "Whirlwind (Nekthara the Mangler)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["332708"] = {
  --desc = "Ground Smash (Heavin the Breaker)";
  sound = 3;
  damageMinimum = 20000;
  test = true;
};

GTFO.SpellID["321041"] = {
  --desc = "Disgusting Burst (Disgusting Refuse)";
  sound = 3;
};

GTFO.SpellID["330608"] = {
  --desc = "Vile Eruption (Rancid Gasbag)";
  sound = 3;
};

GTFO.SpellID["323406"] = {
  --desc = "Jagged Gash (Gorechop)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["317367"] = {
  --desc = "Necrotic Volley (Kul'tharok)";
  sound = 3;
};

GTFO.SpellID["331243"] = {
  --desc = "Bone Spikes (Soulforged Bonereaver)";
  sound = 3;
};

GTFO.SpellID["333294"] = {
  --desc = "Bone Spear (Bone Magus)";
  sound = 3;
};

GTFO.SpellID["332731"] = {
  --desc = "Debilitating Filth";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["319567"] = {
  --desc = "Grasping Hands (Kul'tharok)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["330592"] = {
  --desc = "Vile Eruption (Rancid Gasbag)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["321768"] = {
  --desc = "On the Hook";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["339751"] = {
  --desc = "Ghostly Charge (Echo Bullrider)";
  sound = 3;
};


--- *********************
--- * The Necrotic Wake *
--- *********************

GTFO.SpellID["320596"] = {
  --desc = "Heaving Retch (Blightbone)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["324323"] = {
  --desc = "Gruesome Cleave (Skeletal Marauder)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["324391"] = {
  --desc = "Grave Spikes (Skeletal Monstrosity)";
  sound = 3;
};

GTFO.SpellID["320365"] = {
  --desc = "Embalming Ichor (Surgeon Stitchflesh)";
  sound = 3;
};

GTFO.SpellID["327240"] = {
  --desc = "Spine Crush (Loyal Creation)";
  sound = 3;
};

--- *****************
--- * De Other Side *
--- *****************

GTFO.SpellID["340026"] = {
  --desc = "Wailing Grief (Mythresh, Sky's Talons)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["320232"] = {
  --desc = "Explosive Contrivance (Dealer Xy'exa)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["320723"] = {
  --desc = "Displaced Blastwave (Dealer Xy'exa)";
  sound = 3;
};

GTFO.SpellID["328729"] = {
  --desc = "Dark Lotus (Risen Cultist)";
  sound = 3;
};

GTFO.SpellID["331398"] = {
  --desc = "Volatile Capacitor (Volatile Memory)";
  sound = 3;
};

GTFO.SpellID["323118"] = {
  --desc = "Blood Barrage (Hakkar the Soulflayer)";
  applicationOnly = true;
  sound = 3;
  test = true;
};

GTFO.SpellID["323136"] = {
  --desc = "Anima Starstorm (Runestag Elderhorn)";
  soundHeroic = 3;
  soundChallenge = 3;
  sound = 0;
};

GTFO.SpellID["334913"] = {
  --desc = "Master of Death (Mueh'zala)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["325691"] = {
  --desc = "Cosmic Collapse (Mueh'zala)";
  sound = 3;
};

GTFO.SpellID["326171"] = {
  --desc = "Shatter Reality (Mueh'zala)";
  sound = 3;
};

GTFO.SpellID["331008"] = {
  --desc = "Icky Sticky (Experimental Sludge)";
  applicationOnly = true;
  sound = 3;
};


--- ************
--- * Torghast *
--- ************

GTFO.SpellID["348131"] = {
  --desc = "Soul Emanation";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["292903"] = {
  --desc = "Massive Strike (Empowered Mawsworn Guard)";
  sound = 3;
};

GTFO.SpellID["326056"] = {
  --desc = "Anima Missile";
  sound = 3;
};

GTFO.SpellID["306772"] = {
  --desc = "Massive Scythe";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["330347"] = {
  --desc = "Flamestrike (Forge Keeper)";
  sound = 3;
};

GTFO.SpellID["307115"] = {
  --desc = "Flame Vent";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["325514"] = {
  --desc = "Flame Jet";
  sound = 3;
};

GTFO.SpellID["331295"] = {
  --desc = "Burning (Fire Spike)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["331310"] = {
  --desc = "Burning (Green Spike)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["331349"] = {
  --desc = "Spike Trap";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["331321"] = {
  --desc = "Spike Trap";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["298172"] = {
  --desc = "Collapse (Kosarus the Fallen)";
  sound = 3;
};

GTFO.SpellID["319813"] = {
  --desc = "Soul Emanation";
  sound = 3;
};

GTFO.SpellID["295945"] = {
  --desc = "Rat Traps";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["294173"] = {
  --desc = "Hulking Charge (Warden Arkoban)";
  sound = 3;
};

GTFO.SpellID["294405"] = {
  --desc = "Discordant Barrage (Deadsoul Echo)";
  sound = 3;
};

GTFO.SpellID["294533"] = {
  --desc = "Soulblast Nova (Deadsoul Devil)";
  sound = 3;
};

GTFO.SpellID["333091"] = {
  --desc = "Lance of Darkness (Coldheart Ambusher)";
  sound = 3;
};

GTFO.SpellID["322724"] = {
  --desc = "Divebomb (Coldheart Ambusher)";
  sound = 3;
};

GTFO.SpellID["308096"] = {
  --desc = "Crashing Inferno (Empowered Flameforge Master)";
  sound = 3;
};

GTFO.SpellID["308098"] = {
  --desc = "Crashing Inferno (Empowered Flameforge Master)";
  sound = 3;
};

GTFO.SpellID["296355"] = {
  --desc = "Subjugate Spirit (Subjugator Klontzas)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["296372"] = {
  --desc = "Subjugate Soul (Subjugator Klontzas)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["296365"] = {
  --desc = "Subjugate Essence (Subjugator Klontzas)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["307023"] = {
  --desc = "Soul Burst";
  sound = 3;
};

GTFO.SpellID["303678"] = {
  --desc = "Bone Shrapnel (Skeletal Remains)";
  sound = 3;
};

GTFO.SpellID["321662"] = {
  --desc = "Bone Spike (Bone Husk)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["330813"] = {
  --desc = "Aerial Strikes (Observer Zelgar)";
  sound = 3;
};

GTFO.SpellID["355173"] = {
  --desc = "Bombardment";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["352223"] = {
  --desc = "Tortured Stomp (Vault Sentinel)";
  sound = 3;
};

GTFO.SpellID["319689"] = {
  --desc = "Spinning Blade";
  sound = 3;
};

GTFO.SpellID["355226"] = {
  --desc = "Lesser Subjugate Essence";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["355224"] = {
  --desc = "Lesser Subjugate Spirit";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["352265"] = {
  --desc = "Ritual of Pain";
  sound = 3;
};

GTFO.SpellID["351931"] = {
  --desc = "Pain Bringer";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["351811"] = {
  --desc = "Fire and Brimestone (Mawsworn Cremator)";
  sound = 3;
};

--- ******************
--- * Castle Nathria *
--- ******************

GTFO.SpellID["330711"] = {
  --desc = "Earsplitting Shriek (Shriekwing)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["330712"] = {
  --desc = "Earsplitting Shriek (Shriekwing)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["343022"] = {
  --desc = "Echoing Sonar (Shriekwing)";
  sound = 3;
};

GTFO.SpellID["343005"] = {
  --desc = "Blind Swipe (Shriekwing)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["345425"] = {
  --desc = "Murder Prey (Shriekwing)";
  sound = 3;
};

GTFO.SpellID["343024"] = {
  --desc = "Horrified (Shriekwing)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["341441"] = {
  --desc = "Ground Smash (Hulking Gargon)";
  sound = 3;
};

GTFO.SpellID["326455"] = {
  --desc = "Fiery Strike (Shade of Kael'thas)";
  sound = 3;
  tankSound = 0;
  test = true;
};

GTFO.SpellID["339649"] = {
  --desc = "Gorging Leap (Gorging Mite)";
  sound = 3;
};

GTFO.SpellID["342777"] = {
  --desc = "Eradication Seeds (Sinister Antiquarian)";
  sound = 3;
};

GTFO.SpellID["329256"] = {
  --desc = "Rift Blast (Artificer Xy'mox)";
  sound = 3;
};

GTFO.SpellID["329107"] = {
  --desc = "Extinction (Artificer Xy'mox)";
  sound = 3;
};

GTFO.SpellID["341404"] = {
  --desc = "Orbital Explosion (Anima Orb)";
  sound = 3;
};

GTFO.SpellID["329518"] = {
  --desc = "Blazing Surge (Shade of Kael'thas)";
  sound = 3;
};

GTFO.SpellID["345775"] = {
  --desc = "Scorching Entrance (Shade of Kael'thas)";
  sound = 3;
};

GTFO.SpellID["327619"] = {
  --desc = "Waltz of Blood (Lord Stavros - Waltzing Venthyr)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["330848"] = {
  --desc = "Wrong Moves";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["335298"] = {
  --desc = "Giant Fists (Sludgefist)";
  sound = 3;
  tankSound = 0;
  test = true;
};

GTFO.SpellID["332572"] = {
  --desc = "Falling Rubble (Sludgefist)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["339067"] = {
  --desc = "Heedless Charge (Sludgefist)";
  sound = 3;
};

GTFO.SpellID["335295"] = {
  --desc = "Shattering Chain (Sludgefist)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["327610"] = {
  --desc = "Evasive Lunge (Lord Stavros)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["336231"] = {
  --desc = "Cluster Bombardment (Stone Legion Commando)";
  sound = 3;
};

GTFO.SpellID["334500"] = {
  --desc = "Seismic Upheaval (General Grashaal)";
  sound = 3;
};

GTFO.SpellID["334016"] = {
  --desc = "Unworthy (Sire Denathrius)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["341732"] = {
  --desc = "Searing Censure (Lady Sinsear)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["329835"] = {
  --desc = "Obliterating Rift (Hungering Destroyer)";
  sound = 2;
};

GTFO.SpellID["327464"] = {
  --desc = "Turbulent Anima (Sire Denathrius)";
  sound = 3;
};

GTFO.SpellID["336162"] = {
  --desc = "Crescendo (Crimson Cabalist)";
  sound = 3;
};

GTFO.SpellID["330137"] = {
  --desc = "Massacre (Sire Denathrius)";
  sound = 3;
};

--- *************************
--- * Sanctum of Domination *
--- *************************

GTFO.SpellID["347671"] = {
  --desc = "Hungering Mist (The Tarragrue)";
  sound = 3;
};

GTFO.SpellID["347737"] = {
  --desc = "Hungering Mist (The Tarragrue)";
  sound = 3;
};

GTFO.SpellID["350217"] = {
  --desc = "Torment (Soulrender Dormazain)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["351229"] = {
  --desc = "Rendered Soul (Soulrender Dormazain)";
  sound = 3;
};

GTFO.SpellID["355302"] = {
  --desc = "Chain Burst (Mawsworn Interceptor)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["358191"] = {
  --desc = "Soul Emanation (Soul Brazier)";
  sound = 3;
};

GTFO.SpellID["357221"] = {
  --desc = "Release Souls (Shadowsteel Colossus)";
  sound = 3;
};

GTFO.SpellID["350031"] = {
  --desc = "Agatha's Eternal Blade (Agatha)";
  sound = 3;
};

GTFO.SpellID["358978"] = {
  --desc = "Spite (Remnant of Ner'zhul)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["354479"] = {
  --desc = "Spite (Remnant of Ner'zhul)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["350076"] = {
  --desc = "Grasp of Malice (Remnant of Ner'zhul)";
  sound = 3;
};

GTFO.SpellID["349890"] = {
  --desc = "Suffering (Remnant of Ner'zhul)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["357435"] = {
  --desc = "Seeds of Fire (Borr-Gahn)";
  sound = 3;
};

GTFO.SpellID["358980"] = {
  --desc = "Dark Wind (High Torturer)";
  sound = 3;
};

GTFO.SpellID["358197"] = {
  --desc = "Searing Scythe";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["355526"] = {
  --desc = "Spiked (Painsmith Raznal)";
  sound = 3;
};

GTFO.SpellID["348363"] = {
  --desc = "Spiked Ball (Painsmith Raznal)";
  sound = 3;
};

GTFO.SpellID["355535"] = {
  --desc = "Shadowsteel Embers (Painsmith Raznal)";
  sound = 3;
};

GTFO.SpellID["352833"] = {
  --desc = "Disintegration (Guardian of the First Ones)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["350355"] = {
  --desc = "Fated Conjunction (Fatescribe Roh-Kalo)";
  sound = 3;
};

GTFO.SpellID["353162"] = {
  --desc = "Fate Fragment (Fatescribe Roh-Kalo)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["349806"] = {
  --desc = "Demolish (Unstoppable Abomination)";
  sound = 3;
};

GTFO.SpellID["346469"] = {
  --desc = "Glacial Wrath (Kel'Thuzad)";
  sound = 3;
};

GTFO.SpellID["355058"] = {
  --desc = "Glacial Winds (Kel'Thuzad)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["352381"] = {
  --desc = "Freezing Blast (Kel'Thuzad)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["352355"] = {
  --desc = "Undying Wrath (Kel'Thuzad)";
  sound = 3;
};

GTFO.SpellID["352002"] = {
  --desc = "Shadow Fissure (Kel'Thuzad)";
  sound = 3;
};

GTFO.SpellID["354107"] = {
  --desc = "Relentless Haunt (Frostbound Devoted)";
  sound = 3;
};

GTFO.SpellID["356377"] = {
  --desc = "Desecrating Shot (Sylvanas Windrunner)";
  sound = 3;
};

GTFO.SpellID["352318"] = {
  --desc = "Domination Chains (Sylvanas Windrunner)";
  sound = 3;
};

GTFO.SpellID["347704"] = {
  --desc = "Veil of Darkness (Sylvanas Windrunner)";
  applicationOnly = true;
  sound = 2;
};

GTFO.SpellID["348145"] = {
  --desc = "Rive (Sylvanas Windrunner)";
  sound = 3;
};

GTFO.SpellID["356649"] = {
  --desc = "Calamity (Sylvanas Windrunner)";
  sound = 3;
};

GTFO.SpellID["351870"] = {
  --desc = "Haunting Wave (Sylvanas Windrunner)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["353413"] = {
  --desc = "Riven Debris (Sylvanas Windrunner)";
  sound = 3;
};

GTFO.SpellID["348109"] = {
  --desc = "Banshee Wail (Sylvanas Windrunner)";
	soundFunction = function() -- Warn only if you get hit more than once within 5 seconds
		if (GTFO_FindEvent("SylvanasBansheeWail")) then
			return 3;
		end
		GTFO_AddEvent("SylvanasBansheeWail", 5);
		return 0;
	end
};

GTFO.SpellID["357091"] = {
  --desc = "Cleave Flesh (Bonesteel)";
  applicationOnly = true;
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["355063"] = {
  --desc = "Crushing Strike (Mawsworn Guard)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["358747"] = {
  --desc = "Magma Wave (Borr-Gahn)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["353069"] = {
  --desc = "Fractured Soul";
  applicationOnly = true;
  sound = 3;
  test = true;
};

GTFO.SpellID["358205"] = {
  --desc = "Incinerating Cleave (Screamspike)";
  applicationOnly = true;
  sound = 3;
  tankSound = 0;
};


--- *******************************
--- * Tazavesh, the Veiled Market *
--- *******************************

GTFO.SpellID["355903"] = {
  --desc = "Disruption Grenade (Customs Security)";
  sound = 3;
};

GTFO.SpellID["356482"] = {
  --desc = "Rotten Vegetable (Unruly Patron)";
  sound = 3;
};

GTFO.SpellID["355502"] = {
  --desc = "Shocklight Barrier";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["355476"] = {
  --desc = "Shock Mines (Commander Zo'far)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["347481"] = {
  --desc = "Shuri (So'azmi)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["355584"] = {
  --desc = "Charged Pulse (Stormforged Guardian)";
  sound = 3;
  test = true;
};

GTFO.SpellID["347422"] = {
  --desc = "Deadly Seas";
  sound = 3;
};

GTFO.SpellID["346877"] = {
  --desc = "Shearing Swings (Hylbrande)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["347149"] = {
  --desc = "Infinite Breath (Timecap'n Hooktail)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["354334"] = {
  --desc = "Hook'd! (Timecap'n Hooktail)";
  sound = 3;
  alwaysAlert = true;
};

GTFO.SpellID["347370"] = {
  --desc = "Grapeshot (Hourglass Cannon)";
  sound = 3;
};

GTFO.SpellID["351101"] = {
  --desc = "Energy Fragmentation (So'leah)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["355306"] = {
  --desc = "Rift Blast (Portalmancer Zo'honn)";
  sound = 3;
};

GTFO.SpellID["357019"] = {
  --desc = "Lightshard Retreat (Cartel Wiseguy)";
  sound = 1;
  applicationOnly = true;
};

GTFO.SpellID["350921"] = {
  --desc = "Crowd Control (Zo'gron)";
  sound = 3;
};

GTFO.SpellID["355440"] = {
  --desc = "Suppression Spark (Zo'gron)";
  sound = 3;
  test = true;
};

GTFO.SpellID["349999"] = {
  --desc = "Anima Detonation (Achillite)";
  sound = 3;
};

GTFO.SpellID["349663"] = {
  --desc = "Grip of Hunger (Alcruux)";
  sound = 3;
};

GTFO.SpellID["349801"] = {
  --desc = "Grand Consumption (Alcruux)";
  sound = 3;
};

GTFO.SpellID["356260"] = {
  --desc = "Tidal Burst (Hourglass Tidesage)";
  sound = 3;
};

GTFO.SpellID["357228"] = {
  --desc = "Drifting Star (Adorned Starseer)";
  sound = 3;
};

GTFO.SpellID["357226"] = {
  --desc = "Drifting Star (Adorned Starseer)";
  sound = 3;
  test = true;
};

GTFO.SpellID["347094"] = {
  --desc = "Titanic Crash (Hylbrande)";
  sound = 3;
};

end

